import React from 'react';

interface TextOutputProps {
  value: string;
}

const TextOutput: React.FC<TextOutputProps> = ({ value }) => {
  return (
    <div className="relative h-96 bg-white border border-gray-300 rounded-xl overflow-hidden group transition-all duration-200 hover:border-green-200">
      <pre className="w-full h-full p-4 whitespace-pre-wrap font-mono text-sm">{value || 'Sanitized text will appear here...'}</pre>
      <div className="absolute inset-0 bg-green-50 bg-opacity-50 flex items-center justify-center pointer-events-none opacity-0 group-hover:opacity-100 transition-opacity duration-200">
        {!value && (
          <div className="text-green-500 bg-white px-4 py-2 rounded-full shadow-md">
            Waiting for input text...
          </div>
        )}
      </div>
    </div>
  );
};

export default TextOutput;